import { EventTarget } from 'event-target-shim';
import { UserStatus, UserFlag, UserProblem } from 'types/UserStatus';
import { Message } from 'types/Message/Message';
import { IssueCallNewNotifyData } from 'types/xiva/IssueCallNewNotify';
import { IssueTimelineUpdateData } from './IssueTimelineUpdateData';
import { ActivityData } from './PersonalCall';

export enum XivaBackendEventType {
  Status = 'status',
  Message = 'message',
  IssueChange = 'change',
  IssueTimelineUpdate = 'issueTimelineUpdate',
  IssueModuleRefresh = 'issueModuleRefresh',
  UpdateUpsale = 'updateUpsale',
  CountersChanged = 'countersChanged',
  IssueCallNewNotify = 'issueCallNewNotify',
  Activities = 'activities',
}

export interface BackendStatus {
  status: UserStatus;
  transitions: UserStatus[];
  flags?: UserFlag[];
  problems?: UserProblem[];
}

export interface BackendEvent<Type, Data> {
  type: Type;
  timestamp: string;
  data: Data;
}

export interface BackendMessageData {
  message?: string;
  messages?: Message[];
}

export interface BackendIssueChangeData {
  issueId: number;
}

export interface BackendUpdateUpsaleData {
  accountId: number;
  ycCallId?: string;
}

export type BackendCountersChangedData = {
  id: number;
  value: string;
}[];

export type BackendEvents = BackendEvent<XivaBackendEventType.Status, BackendStatus>;

export type CRMXivaCustomEvent<T = never> = CustomEvent<T> & { serverNotifyId: string };

export type XivaBackendEvents = {
  [XivaBackendEventType.Status]: CRMXivaCustomEvent<BackendStatus>;
  [XivaBackendEventType.Message]: CRMXivaCustomEvent<BackendMessageData>;
  [XivaBackendEventType.IssueChange]: CRMXivaCustomEvent<BackendIssueChangeData>;
  [XivaBackendEventType.IssueModuleRefresh]: CRMXivaCustomEvent;
  [XivaBackendEventType.UpdateUpsale]: CRMXivaCustomEvent<BackendUpdateUpsaleData>;
  [XivaBackendEventType.CountersChanged]: CRMXivaCustomEvent<BackendCountersChangedData>;
  [XivaBackendEventType.IssueTimelineUpdate]: CRMXivaCustomEvent<IssueTimelineUpdateData>;
  [XivaBackendEventType.IssueCallNewNotify]: CRMXivaCustomEvent<IssueCallNewNotifyData>;
  [XivaBackendEventType.Activities]: CRMXivaCustomEvent<ActivityData>;
};

export interface CRMXiva extends EventTarget<XivaBackendEvents, {}> {
  addTag(tag: string): void;
  removeTag(tag: string): void;
  addTopic(topic: string): void;
  removeTopic(topic: string): void;
  destroy(): void;
}
