import { EType } from 'types/entities';

export type CallStatus =
  | 'callStarted'
  | 'callOperatorRejected'
  | 'callOperatorAnswered'
  | 'callFinished'
  | 'update';

interface BaseActivityData {
  id: number;
  status: CallStatus;
  type: EType;
}

export interface CallActivityData extends BaseActivityData {
  type: EType.YcCall;
}

export type ActivityData = CallActivityData | BaseActivityData;

export const isCallActivityData = (data: BaseActivityData): data is CallActivityData => {
  return data.type === EType.YcCall;
};
