import { jsonApiCall } from 'api/common';
import { history } from 'appHistory';
import createI18N from '@yandex-int/i18n';
import { config } from 'services/Config';
import { push } from 'modules/notificationsUI/actions';
import * as keyset from './accounts.i18n';
import { accountLink } from './utils/linkCreator';
import { getFilter, getSelectedAccounts, getSelectedAllAccounts } from './modules/table/selectors';
import { isAccountPath } from './utils/isAccountPath';
import { getAccountId } from './modules/info/selectors';

const i18nMoveDataInHour = createI18N(keyset)('moveDataInHour');

export const append = (massmailId) => (dispatch, getState) => {
  const data = { massmailId };
  const state = getState();
  if (isAccountPath(history.location.pathname)) {
    data.accountId = getAccountId(state);
  } else {
    data.accountFilter = getFilter(state);
    if (config.value.features.massMailImprovements) {
      data.accountIds = getSelectedAccounts(state);
      data.includeAll = getSelectedAllAccounts(state);
    }
  }

  return jsonApiCall({
    url: '/actions/massmail/account/append',
    data,
  });
};

const routeToTargetAccount = (dispatch, accountId) => {
  dispatch(push({ theme: 'success', text: i18nMoveDataInHour }));
  history.push(accountLink(accountId));
};

export const moveToNewAccount = (client) => (dispatch) => {
  routeToTargetAccount(dispatch, client.id);
};

export const moveToAccount = (leadId, accountId) => (dispatch) =>
  jsonApiCall({
    url: '/actions/lead/moveToAccount',
    data: {
      leadId,
      accountId,
    },
  }).then((data) => {
    routeToTargetAccount(dispatch, accountId);
    return data;
  });
