import React from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';
import LegoLink from 'lego/react-router/Link';
import { accountLink } from '../utils/linkCreator';

const AccountLink = props => {
  const { accountId, account, theme, ...passPropsThrough } = props;

  const Component = theme ? LegoLink : Link;

  if (account) {
    const { id, name, login } = account;

    return (
      <Component to={accountLink(id)} target="_blank" {...passPropsThrough} theme={theme}>
        {name}
        {!!login && ` (${login})`}
      </Component>
    );
  }

  return (
    <Component to={accountLink(accountId)} target="_blank" {...passPropsThrough} theme={theme} />
  );
};

AccountLink.propTypes = {
  accountId: PropTypes.number,
  account: PropTypes.instanceOf(Object),
  theme: PropTypes.string,
};

AccountLink.defaultProps = {
  accountId: undefined,
  account: undefined,
  theme: undefined,
};

export default AccountLink;
