import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './styles.modules.scss';

const AccountInputSuggestItem = ({ item: { name, login } }) => (
  <span className={cx(css.agency_item)}>
    <span className={css.agency_item__name}>{name}</span>
    <span className={css.agency_item__login}>{login}</span>
  </span>
);

AccountInputSuggestItem.propTypes = {
  item: PropTypes.instanceOf(Object).isRequired,
};

export default AccountInputSuggestItem;
