import React from 'react';
import { connect } from 'react-redux';
import PropTypes from 'prop-types';
import { Field, formValueSelector } from 'redux-form';
import { baseCallApi } from 'entry/api/common';
import SuggestWithTags from 'lego/redux-form/SuggestWithTags';
import filterList from '../../../utils/filterArray';
import AccountInputSuggestItem from './AccountInputSuggestItem';

class AccountInput extends React.Component {
  static ACCOUNT_TYPES = {
    AGENCY: 'Agency',
    CONTRACTOR: 'Contractor',
  };

  constructor(props) {
    super(props);

    this.state = {
      items: [],
    };
  }

  componentDidMount() {
    const { managerId, accountType } = this.props;
    const request = {
      url: '/view/manager/account/list',
      data: {
        managerId,
        accountType,
      },
    };

    baseCallApi(request).then(data => {
      this.setState({ items: data.items });
    });
  }

  provider = text => filterList(this.state.items, text);

  render() {
    const { managerId, ...passThroughProps } = this.props;

    return (
      <Field
        component={SuggestWithTags}
        provider={this.provider}
        showOnFocus
        props={{
          component: AccountInputSuggestItem,
        }}
        {...passThroughProps}
      />
    );
  }
}

AccountInput.propTypes = {
  theme: PropTypes.instanceOf(Object),
  managerId: PropTypes.number.isRequired,
  accountType: PropTypes.string,
};

AccountInput.defaultProps = {
  theme: {},
  accountType: AccountInput.ACCOUNT_TYPES.AGENCY,
};

const mapState = (state, props) => {
  if (props.form) {
    const selector = formValueSelector(props.form);

    return {
      managerId: selector(state, 'filter.managerId'),
    };
  }

  return {};
};

export default connect(mapState)(AccountInput);
