import React from 'react';
import PropTypes from 'prop-types';

const AdServerPreview = ({ data, value }) => {
  const adServer = data || value;

  if (!adServer) {
    return <span>&mdash;</span>;
  }

  return (
    <span>{adServer.name}</span>
  );
};

const adServerShape = PropTypes.shape({
  name: PropTypes.string.isRequired,
});

AdServerPreview.propTypes = {
  value: adServerShape,
  data: adServerShape,
};

AdServerPreview.defaultProps = {
  value: undefined,
  data: undefined,
};

export default AdServerPreview;
