import React from 'react';
import { baseCallApi } from 'api/common';
import SuggestWithTags from 'lego/redux-form/SuggestWithTags';
import CityPreview from './CityPreview';

const getSuggest = regionNamePart => {
  const request = {
    url: '/view/dicts/geo/cities',
    data: { regionNamePart },
  };

  return baseCallApi(request);
};

const CityEdit = props => (
  <SuggestWithTags
    provider={getSuggest}
    component={CityPreview}
    tagComponent={CityPreview}
    isSingleValue
    {...props}
  />
);

export default CityEdit;
