import React from 'react';
import PropTypes from 'prop-types';

const City = ({ item, value }) => {
  const city = item || value;

  if (!city) {
    return <span>&mdash;</span>;
  }

  return (
    <span>
      {city.name} ({city.regionPath})
    </span>
  );
};

const cityShape = PropTypes.shape({
  name: PropTypes.string.isRequired,
  regionPath: PropTypes.string.isRequired,
});

City.propTypes = {
  value: cityShape,
  item: cityShape,
};

City.defaultProps = {
  value: undefined,
  item: undefined,
};

export default City;
