import React from 'react';
import { ModalForm as ClientFind } from 'modules/clientSelectForm';
import Tags from 'lego/components/Tags';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';

const CLIENT_FIND_TYPES = ['contractor'];

interface Props {
  size: LegoSizeProp;
  className: string;
  input: any;
}

const render = (item) => {
  const info = item && item.info;

  if (!info) {
    return null;
  }

  return `${info.name}${info.organization ? ` (${info.organization.name})` : ''}`;
};

const listAccount2CardAccount = (item) => ({
  id: item.id,
  info: item,
});

const getKey = (item) => item.id;

const ContractorArrayInput = (props: Props) => {
  const {
    input: { value, onChange },
    className,
    size,
  } = props;

  return (
    <ClientFind
      name="ContractorInput"
      onSubmit={(account) => {
        const arr = value || [];
        if (!arr.find((item) => getKey(item) === getKey(account))) {
          onChange(arr.concat(listAccount2CardAccount(account)));
        }
      }}
      newClient={false}
      forceAccountTypes={CLIENT_FIND_TYPES}
    >
      {(modal, open) => (
        <React.Fragment>
          <Tags
            className={className}
            onAdd={open}
            items={value}
            size={size}
            render={render}
            getKey={getKey}
            onDelete={(id) => {
              onChange((value || []).filter((item) => getKey(item) !== id));
            }}
          />
          {modal}
        </React.Fragment>
      )}
    </ClientFind>
  );
};

export default ContractorArrayInput;
