import React from 'react';
import { ModalForm as ClientFind } from 'modules/clientSelectForm';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';
import ComboInput from 'lego/components/ComboInput';

const CLIENT_FIND_TYPES = ['contractor'];

interface Props {
  size: LegoSizeProp;
  className: string;
  input: any;
}

const ContractorInput = (props: Props) => {
  const {
    input: { value, onChange },
    className,
    size,
  } = props;

  return (
    <ClientFind
      name="ContractorInput"
      onSubmit={onChange}
      newClient={false}
      forceAccountTypes={CLIENT_FIND_TYPES}
    >
      {(modal, open) => (
        <ComboInput
          className={className}
          onChange={open}
          onClear={() => onChange(null)}
          value={value ? value.name : undefined}
          changeNode={modal}
          size={size}
        />
      )}
    </ClientFind>
  );
};

export default ContractorInput;
