import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Field } from 'redux-form';
import { apiCall } from 'entry/api/common';
import SuggestWithTags from 'lego/redux-form/SuggestWithTags';
import filterList from '../../utils/filterArray';

class DictionaryInput extends Component {
  constructor(props) {
    super(props);

    this.state = {
      dictionary: [],
    };
  }

  componentWillMount() {
    apiCall(this.props.url).then(data => {
      this.setState({ dictionary: data.items });
    });
  }

  provider = text => filterList(this.state.dictionary, text);

  render() {
    return (
      <Field component={SuggestWithTags} provider={this.provider} showOnFocus {...this.props} />
    );
  }
}

DictionaryInput.propTypes = {
  url: PropTypes.string.isRequired,
};

export default DictionaryInput;
