import React, { Component } from 'react';
import { Field } from 'redux-form';
import { apiCall } from 'entry/api/common';
import SuggestWithTags from 'lego/redux-form/SuggestWithTags';
import filterList from '../../utils/filterArray';

class TagInput extends Component {
  constructor(props) {
    super(props);

    this.state = {
      tags: [],
    };
  }

  componentWillMount() {
    apiCall('/view/account/tag/list').then(data => {
      this.setState({ tags: data.items });
    });
  }

  provider = text => filterList(this.state.tags, text);

  render() {
    return (
      <Field component={SuggestWithTags} provider={this.provider} showOnFocus {...this.props} />
    );
  }
}

export default TagInput;
