import React from 'react';
import PropTypes from 'prop-types';
import Toolbar from '../Toolbar';
import css from './styles.modules.scss';

const ClientLayout = props => {
  const {
    onFilterChange,
    onClientSelect,
    onClientCreate,
    onFilterNew,
    onFilterSave,
    moveToAccount,
    moveToNewAccount,
    children,
    clientId,
    canMerge,
    canMoveHistory,
  } = props;

  return (
    <div className={css.root}>
      <div className={css.column}>
        <Toolbar
          onFilterChange={onFilterChange}
          onFilterNew={onFilterNew}
          onFilterSave={onFilterSave}
          onClientSelect={onClientSelect}
          onClientCreate={onClientCreate}
          moveToAccount={moveToAccount}
          moveToNewAccount={moveToNewAccount}
          clientId={clientId}
          canMerge={canMerge}
          canMoveHistory={canMoveHistory}
        />
        <div className={css.row}>{children}</div>
      </div>
    </div>
  );
};

ClientLayout.propTypes = {
  onFilterChange: PropTypes.func.isRequired,
  onClientSelect: PropTypes.func.isRequired,
  onClientCreate: PropTypes.func.isRequired,
  onFilterNew: PropTypes.func.isRequired,
  onFilterSave: PropTypes.func.isRequired,
  moveToAccount: PropTypes.func.isRequired,
  moveToNewAccount: PropTypes.func.isRequired,
  children: PropTypes.node,
  clientId: PropTypes.number,
  canMerge: PropTypes.bool,
  canMoveHistory: PropTypes.bool,
};

ClientLayout.defaultProps = {
  clientId: undefined,
  children: undefined,
  canMerge: false,
  canMoveHistory: false,
};

export default ClientLayout;
