import React from 'react';
import PropTypes from 'prop-types';
import { StatefulPopup } from '@crm/components/dist/lego2/Popup';
import MassmailList from 'modules/massmail/containers/ListWithNew';
import css from './styles.modules.scss';

const Massmails = (props) => {
  const { children, rootComponent: RootComponent, append } = props;

  return (
    <StatefulPopup
      content={
        <MassmailList
          className={css.root}
          classNameItem={css.item}
          classNameNewComponent={css.add}
          newComponent="div"
          onClick={append}
          redirect
          onlyDraft
          noHeaders
        />
      }
      directions="bottom"
      zIndex={100}
    >
      <RootComponent>{children}</RootComponent>
    </StatefulPopup>
  );
};

Massmails.propTypes = {
  children: PropTypes.node,
};

Massmails.defaultProps = {
  children: 'Добавить к рассылке',
};

export default Massmails;
