import React from 'react';
import PropTypes from 'prop-types';
import { Link as LinkRouter } from 'react-router-dom';
import createI18N from '@yandex-int/i18n';
import url from 'utils/url';
import * as keyset from '../accounts.i18n';
import { PATH_ACCOUNTS } from '../index';

const i18n = createI18N(keyset);
const i18nAgencyClients = i18n('agencyClients');
const i18nContractorAccounts = i18n('contractorAccounts');

const CONFIG = {
  Agency: {
    text: i18nAgencyClients,
    filterKey: 'agency',
    type: ['SubClient'],
  },
  Contractor: {
    text: i18nContractorAccounts,
    filterKey: 'contractor',
    type: ['Any'],
  },
};

const SubAccountsLink = props => {
  const { name, type, id } = props;

  const config = CONFIG[type];

  if (!config) {
    return null;
  }

  return (
    <LinkRouter
      target="_blank"
      to={{
        pathname: PATH_ACCOUNTS,
        search: `?${url.serialize({
          filter: {
            type: config.type,
            managerIds: [-1],
            [config.filterKey]: [{ id, name }],
          },
        })}`,
      }}
    >
      {config.text}
    </LinkRouter>
  );
};

SubAccountsLink.propTypes = {
  type: PropTypes.string.isRequired,
  name: PropTypes.string.isRequired,
  id: PropTypes.number.isRequired,
};

export default SubAccountsLink;
