import React from 'react';
import PropTypes from 'prop-types';
import { ImperativePopup } from '@crm/components/dist/lego2/Popup';
import { ModalForm as ClientFind } from 'modules/clientSelectForm';
import { ModalForm as ClientCreate } from 'modules/clientCreateForm';
import createI18N from '@yandex-int/i18n';
import * as keyset from './Toolbar.i18n';
import Button from './Button';
import css from '../Massmails/styles.modules.scss';

const i18n = createI18N(keyset);
const i18nToExisting = i18n('toExisting');
const i18nToNew = i18n('toNew');
const i18nMoveToAccount = i18n('moveToAccount');

const MoveInAccount = ({ leadId, moveToAccount, moveToNewAccount }) => (
  <ClientFind name="MOVE_TO_CLIENT" onSubmit={(account) => moveToAccount(leadId, account.id)}>
    {(findModal, openFindModal) => (
      <ClientCreate
        name="MOVE_TO_NEW_CLIENT"
        initialValues={{ leadId }}
        onSubmit={moveToNewAccount}
      >
        {(newModal, openNewModal) => (
          <ImperativePopup
            className={css.popup__wrap}
            content={(popupBag) => (
              <div>
                <button
                  type="button"
                  className={css.item}
                  onClick={() => {
                    popupBag.hide();
                    openFindModal();
                  }}
                >
                  {i18nToExisting}
                </button>
                <button
                  type="button"
                  className={css.item}
                  onClick={() => {
                    popupBag.hide();
                    openNewModal();
                  }}
                >
                  {i18nToNew}
                </button>
              </div>
            )}
            toggle={(popupBag) => (
              <React.Fragment>
                <Button ref={popupBag.ref} onClick={popupBag.toggle}>
                  {i18nMoveToAccount} <i className="material-icons">expand_more</i>
                </Button>
                {findModal}
                {newModal}
              </React.Fragment>
            )}
            directions="bottom"
            zIndex={100}
          />
        )}
      </ClientCreate>
    )}
  </ClientFind>
);

MoveInAccount.propTypes = {
  leadId: PropTypes.number,
  moveToAccount: PropTypes.func.isRequired,
  moveToNewAccount: PropTypes.func.isRequired,
};

MoveInAccount.defaultProps = {
  leadId: undefined,
};

export default MoveInAccount;
