import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import Access from 'utils/Access';
import Layout from '../components/Layout';
import { PATH_ACCOUNTS } from '../constants';
import { accountLink } from '../utils/linkCreator';
import { setFilter, setFilterNew, initializeForm } from '../modules/table';
import { moveToAccount, moveToNewAccount } from '../actions';
import { getAccountId, getAccountType, getActionMoveHistory } from '../modules/info/selectors';

const mapState = state => {
  const clientId = getAccountId(state);

  return {
    clientId,
    canMerge: getAccountType(state) === 'Lead',
    canMoveHistory: Access.isEdit(getActionMoveHistory(state)) && !!clientId,
  };
};

const mapDispatch = (dispatch, props) => ({
  onFilterChange: id => {
    if (props.location.pathname !== PATH_ACCOUNTS) {
      props.history.push(PATH_ACCOUNTS);
    }
    dispatch(setFilter(id));
  },
  onFilterNew: () => {
    if (props.location.pathname !== PATH_ACCOUNTS) {
      props.history.push(PATH_ACCOUNTS);
    }
    dispatch(setFilterNew());
  },
  onFilterSave: (id, filter) => {
    dispatch(initializeForm(filter));
  },
  onClientSelect: client => {
    props.history.push(accountLink(client.id));
  },
  onClientCreate: client => {
    props.history.push(accountLink(client.id));
  },
  ...bindActionCreators({ moveToNewAccount, moveToAccount }, dispatch),
});

export default connect(
  mapState,
  mapDispatch,
)(Layout);
