import { jsonApiCall } from 'api/common';
import { schema } from 'normalizr';
import { CALL_API } from 'middlewares/api';
import * as aTypes from './actionTypes';

const listSchema = new schema.Entity('list', {}, { idAttribute: () => 'root' });
const filterSchema = new schema.Entity('filter');
listSchema.define({
  items: [filterSchema],
});

export const load = () => ({
  type: [CALL_API],
  [CALL_API]: {
    types: [aTypes.LOAD_REQUEST, aTypes.LOAD_RECEIVE, aTypes.LOAD_FAIL],
    endpoint: '/view/account/filter/list',
    schema: listSchema,
  },
});

export const remove = filterId => ({
  type: 'PROMISE',
  args: filterId,
  promise: jsonApiCall({
    url: '/actions/account/filter/remove',
    data: { filterId },
  }),
  actions: [aTypes.REMOVE_REQUEST, aTypes.REMOVE_RECEIVE, aTypes.REMOVE_FAIL],
});

export const save = (filter = {}) => ({
  type: 'PROMISE',
  args: filter,
  promise: jsonApiCall({
    url: '/actions/account/filter/save',
    data: {
      filter,
      filterId: filter.id,
      name: filter.name,
    },
  }),
  actions: [aTypes.SAVE_REQUEST, aTypes.SAVE_RECEIVE, aTypes.SAVE_FAIL],
});

export const saveAsNew = filter => save({ ...filter, id: undefined });

export const clearTriggerSave = () => ({ type: aTypes.CLEAR_TRIGGER_SAVE });
