import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import Button from '@crm/components/dist/lego2/Button/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import * as keyset from '../filtersList.i18n';
import css from './styles.module.css';

const i18nRemoveConfirm = createI18N(keyset)('removeConfirm');

const FilterItem = ({ filter, onRemove, onClick, newItem }) => {
  const handleRemove = (e) => {
    e.stopPropagation();
    if (global.confirm(i18nRemoveConfirm)) {
      onRemove();
    }
  };

  return (
    <div className={cx(css.item, { [css.item_new]: newItem })} onClick={onClick}>
      <span className={css.item__name}>{filter && filter.name}</span>
      {!newItem && (
        <Button
          size="xs"
          view="clear"
          onClick={handleRemove}
          icon={(className) => <Icon className={className} type="close" />}
        />
      )}
    </div>
  );
};

FilterItem.propTypes = {
  id: PropTypes.number.isRequired,
  name: PropTypes.string.isRequired,
  onRemove: PropTypes.func,
  onClick: PropTypes.func.isRequired,
  newItem: PropTypes.bool,
  // eslint-disable-next-line react/forbid-prop-types
  filter: PropTypes.object.isRequired,
};

FilterItem.defaultProps = {
  onRemove: undefined,
  newItem: false,
};

export default FilterItem;
