import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import * as keyset from '../filtersList.i18n';
import css from './styles.module.css';

const i18n = createI18N(keyset);

const FilterItemNew = ({ name, onClick }) => (
  <div className={cx(css.item, css.item_new)} onClick={onClick}>
    <span className={css.item__name}>{name}</span>
  </div>
);

FilterItemNew.propTypes = {
  name: PropTypes.string,
  onClick: PropTypes.func.isRequired,
};

FilterItemNew.defaultProps = {
  name: i18n('newFilter'),
};

export default FilterItemNew;
