import React from 'react';
import PropTypes from 'prop-types';
import { ImperativePopup } from '@crm/components/dist/lego2/Popup';
import createI18N from '@yandex-int/i18n';
import * as keyset from '../filtersList.i18n';
import FilterItem from '../containers/FilterItem';
import FilterItemNew from './FilterItemNew';
import css from './styles.module.css';

const i18n = createI18N(keyset);

class Filters extends React.Component {
  handleChangeFilter = (id, filter) => {
    this.props.onChange(id, filter);
    this.hidePopup();
  };

  handleNewFilterClick = () => {
    if (typeof this.props.onNew === 'function') {
      this.props.onNew();
    }
    this.hidePopup();
  };

  render() {
    const { list, children, rootComponent: RootComponent } = this.props;

    const content = (popupBag) => {
      this.hidePopup = popupBag.hide;
      return (
        <div className={css.filters}>
          <div className={css.filters__list}>
            {list.map((id) => (
              <FilterItem key={id} id={id} onClick={this.handleChangeFilter} />
            ))}
          </div>
          <FilterItemNew onClick={this.handleNewFilterClick} />
        </div>
      );
    };

    return (
      <ImperativePopup
        content={content}
        toggle={() => <RootComponent>{children}</RootComponent>}
        directions="bottom"
        zIndex={100}
      />
    );
  }
}

Filters.propTypes = {
  onNew: PropTypes.func,
};

Filters.defaultProps = {
  list: [],
  onNew: undefined,
  children: i18n('filters'),
};

export default Filters;
