import { connect } from 'react-redux';
import { getFilter } from '../selectors';
import FilterItem from '../components/FilterItem';
import { remove } from '../actions';

const mapState = (_, { id }) => state => ({
  filter: getFilter(state, id),
});

const mapDispatch = (_, { id, onClick }) => dispatch => ({
  onRemove: () => dispatch(remove(id)),
  onClick: (id, filter) => {
    if (typeof onClick === 'function') {
      onClick(id, filter);
    }
  },
});

const mapMerge = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  onClick: () => { dispatchProps.onClick(ownProps.id, stateProps.filter); },
});

export default connect(mapState, mapDispatch, mapMerge)(FilterItem);
