import React, { createElement } from 'react';
import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import loader from 'hoc/loader';
import { getState, getLastSavedFilter } from '../selectors';
import FiltersDumb from '../components/Filters';
import { load, clearTriggerSave } from '../actions';

const mapState = (state) => {
  const filtersState = getState(state);

  return {
    list: filtersState.list,
    triggerSave: filtersState.triggerSave,
    lastSavedFilter: getLastSavedFilter(state),
  };
};

const mapDispatch = (dispatch, props) => ({
  onMount: () => dispatch(load()),
  onChange: (id, filter) => {
    if (typeof props.onChange === 'function') {
      props.onChange(id, filter);
    }
  },
  ...bindActionCreators({ clearTriggerSave }, dispatch),
});

class Filters extends React.Component {
  componentWillReceiveProps(nextProps) {
    if (nextProps.triggerSave) {
      this.props.clearTriggerSave();
      if (typeof this.props.onSave === 'function') {
        this.props.onSave(nextProps.lastSavedFilter.id, nextProps.lastSavedFilter);
      }
    }
  }

  render() {
    const {
      triggerSave,
      clearTriggerSave,
      lastSavedFilter,
      ...props
    } = this.props;
    return createElement(FiltersDumb, props);
  }
}

export default connect(mapState, mapDispatch)(loader()(Filters));
