import Immutable from 'immutable';
import reducerFactory from 'utils/reducer/reducerFactory';
import * as aTypes from './actionTypes';
import * as filter from './reducers/filter';

const INIT = {
  filters: {},
  list: [],
};

const behaviors = {
  [aTypes.LOAD_REQUEST](state) {
    return state.set('isFetch', true);
  },
  [aTypes.LOAD_RECEIVE](state, { response }) {
    let filters = Immutable.fromJS({});
    response.entities.list.root.items.forEach(id => {
      const currentFilter = state.getIn(['filters', id.toString()]);
      if (currentFilter) {
        filters = filters.set(id, filter.update(currentFilter, response.entities.filter[id]));
      } else {
        filters = filters.set(id, response.entities.filter[id]);
      }
    });

    return state
      .merge({
        isFetch: false,
        isLoad: true,
        list: response.entities.list.root.items,
      })
      .set('filters', filters);
  },
  [aTypes.LOAD_FAIL](state) {
    return state.merge({
      isFetch: false,
    });
  },
  [aTypes.REMOVE_RECEIVE](state, { args }) {
    return state
      .deleteIn(['filters', args.toString()])
      .update('list', list => list.filter(item => item !== args));
  },
  [aTypes.CLEAR_TRIGGER_SAVE](state) {
    return state.remove('triggerSave');
  },
  [aTypes.SAVE_RECEIVE](state, { args, data }) {
    let newState = state
      .setIn(['filters', data.filterId.toString()], { ...args, id: data.filterId })
      .set('lastSavedFilterId', data.filterId);
    if (args.id === undefined) {
      newState = newState.update('list', list => list.push(data.filterId)).set('triggerSave', true);
    }
    return newState;
  },
};

export default reducerFactory(aTypes, behaviors, INIT);
