import get from 'lodash/get';
import { NAME } from './constants';

export const getState = state => get(state, NAME);

export const getFilter = (state, id) => {
  if (state && id) {
    const filtersState = getState(state);
    const filter = get(filtersState, `filters.${id}`);
    if (filter) {
      return filter;
    }
  }

  return null;
};

export const getLastSavedFilter = (state) => {
  const lastSavedFilterId = getState(state).lastSavedFilterId;
  return getFilter(state, lastSavedFilterId);
};
