import { baseCallApi, jsonApiCall } from 'api/common';
import * as aTypes from './actionTypes';

export { setFilter } from 'pages/accounts/modules/table';

export const load = (args) => {
  const { campaignId, ...other } = args;

  let accountData;

  return {
    type: 'PROMISE',
    actions: [aTypes.REQUEST_LOAD, aTypes.RECEIVE_LOAD, aTypes.FAILED_LOAD],
    promise: baseCallApi({ url: '/view/account', data: other })
      .then((data = {}) => {
        let formattedManagers = data.managers;
        if (Array.isArray(formattedManagers)) {
          formattedManagers = formattedManagers.map((item) => ({
            ...item,
            disabled: !item.allowedToUnbind,
          }));
        }

        accountData = {
          ...data,
          campaignId,
          managers: formattedManagers,
        };

        return baseCallApi({ url: `/account/${accountData.id}/tabs` });
      })
      .then((data) => {
        return { ...accountData, tabs: data.data.tabs };
      }),
  };
};

export const edit = (id, args, rawArgs) => ({
  type: 'PROMISE',
  actions: [aTypes.REQUEST_EDIT, aTypes.RECEIVE_EDIT, aTypes.FAILED_EDIT],
  promise: jsonApiCall({
    url: '/actions/client/edit',
    data: {
      ...args,
      id,
    },
  }),
  args: rawArgs,
});

export const destroy = () => ({
  type: aTypes.DESTROY,
});

export const addContact = (contact) => ({
  type: aTypes.ADD_CONTACT,
  payload: contact,
});

export const updateContact = (contact) => ({
  type: aTypes.UPDATE_CONTACT,
  payload: contact,
});

export const saveContact = (args) => ({
  type: 'PROMISE',
  actions: [aTypes.REQUEST_SAVE_CONTACT, aTypes.RECEIVE_SAVE_CONTACT, aTypes.FAILED_SAVE_CONTACT],
  promise: jsonApiCall({
    url: '/actions/account/contact/save',
    data: args,
  }),
});

export const removeContact = (contactId) => ({
  type: 'PROMISE',
  actions: [
    aTypes.REQUEST_REMOVE_CONTACT,
    aTypes.RECEIVE_REMOVE_CONTACT,
    aTypes.FAILED_REMOVE_CONTACT,
  ],
  promise: jsonApiCall({
    url: '/actions/account/contact/delete',
    data: { contactId },
  }),
  args: { contactId },
});
