import { connect } from 'react-redux';
import { destroy, load } from '../../actions';
import { AccountCard } from './AccountCard';
import { NAME } from '../../constants';
import reducers from '../../reducers';
import { isLoad } from '../../selectors';

window.reduxStore.injectReducer(NAME, reducers);

export const AccountCardConnected = connect(
  (state) => ({
    isLoad: isLoad(state),
  }),
  { destroy, load },
)(AccountCard);

export default AccountCardConnected;
