import React, { Component } from 'react';
import { LayoutConnected } from './Layout/Layout.connect';
import { MainTabConnected } from './MainTab/MainTab.connect';
import { LayoutWithAccountHistory } from './LayoutWithAccountHistory';
import { AccountCardProps } from './AccountCard.types';

export class AccountCard extends Component<AccountCardProps> {
  componentDidMount() {
    this.loadIfNeeded();
  }

  componentDidUpdate(prevProps: AccountCardProps) {
    this.loadIfNeeded(prevProps);
  }

  componentWillUnmount() {
    this.props.destroy();
  }

  reload = () => {
    const { id, campaignId, mode } = this.props;

    this.props.load({ id, campaignId, mode });
  };

  loadIfNeeded(prevProps: AccountCardProps = {} as AccountCardProps) {
    const { id: prevAccountId, campaignId: prevCampaignId } = prevProps;
    const { id, campaignId, mode } = this.props;

    if (id && (prevAccountId !== id || prevCampaignId !== campaignId)) {
      this.props.load({ id: id, campaignId: campaignId, mode });
    }
  }

  render() {
    const { id, isLoad, isCompact, ...props } = this.props; // eslint-disable-line no-shadow

    if (!isLoad) {
      return null;
    }

    if (isCompact) {
      return (
        <MainTabConnected accountId={id} isCompact={isCompact} {...props} reload={this.reload} />
      );
    }

    return (
      <LayoutWithAccountHistory key={id} accountId={id}>
        <LayoutConnected accountId={id} {...props} reload={this.reload} />
      </LayoutWithAccountHistory>
    );
  }
}
