import React, { useContext } from 'react';
import { LinkTabs, LinkTab } from 'lego/components/Tabs';
import { LayoutBuilderByScheme } from 'components/LayoutBuilderByScheme';
import createI18N from '@yandex-int/i18n';
import { LayoutComponent } from './Layout.types';
import { MainTabConnected } from '../MainTab/MainTab.connect';
import { AccountUrlContext } from '../../AccountUrlContext';
import * as keyset from '../AccountCard.i18n';
import css from './Layout.module.css';

const i18n = createI18N(keyset);
const mainTab = i18n('mainTab');

export const Layout: LayoutComponent = ({ tabs, ...other }) => {
  const accountUrl = useContext(AccountUrlContext);

  return (
    <LinkTabs
      className={css.Layout}
      classNameHeader={css.Layout__header}
      navigationTheme="start"
      redirectUrl={accountUrl}
    >
      {[
        <LinkTab key="main" path={accountUrl} title={mainTab} className={css.Layout__tabContent}>
          <MainTabConnected {...other} />
        </LinkTab>,
      ].concat(
        tabs.map((tab) => (
          <LinkTab
            key={tab.tabId}
            path={`${accountUrl}/${tab.tabId}`}
            title={tab.tabCaption}
            className={css.Layout__tabContent}
          >
            <LayoutBuilderByScheme
              className={css.Layout__grid}
              blocks={tab.blocks}
              layout={tab.layout}
            />
          </LinkTab>
        )),
      )}
    </LinkTabs>
  );
};
