import React, { FC } from 'react';
import Panel from '../Panel/Panel';
import { LayoutWithAccountHistoryProps } from './LayoutWithAccountHistory.types';
import css from './LayoutWithAccountHistory.module.css';

export const LayoutWithAccountHistory: FC<LayoutWithAccountHistoryProps> = ({
  isCompact,
  children,
  accountId,
}) => {
  if (isCompact) {
    return <>{children}</>;
  }

  return (
    <div className={css.LayoutWithAccountHistory}>
      <div className={css.LayoutWithAccountHistory__contentWrap}>{children}</div>
      <Panel accountId={accountId} />
    </div>
  );
};
