import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { MainTab } from './MainTab';
import { getState } from '../../../selectors';
import * as actions from '../../../actions';
import {
  MainTabDispatchConnectedProps,
  MainTabStateConnectedProps,
  MainTabOwnProps,
} from './MainTab.types';

const mapState = (state) => ({
  ...getState(state),
});

const mapDispatch = (dispatch) => ({
  ...bindActionCreators(actions, dispatch),
  dispatch,
});

export const MainTabConnected = connect<
  MainTabStateConnectedProps,
  MainTabDispatchConnectedProps,
  MainTabOwnProps
>(
  mapState,
  mapDispatch,
)(MainTab);
