/* eslint-disable jsx-a11y/anchor-is-valid */
// TODO: задача на рефакторинг тут https://st.yandex-team.ru/CRM-10144
import React from 'react';
import SubAccountsLink from 'pages/accounts/components/SubAccountsLink';
import Access from 'utils/Access';
import ContactCreateButton from 'modules/contactCreateButton';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import FactorBlocks from 'modules/upsale';
import { AttributesPopup } from 'modules/attributes';
import TitleChain from 'modules/heading';
import * as keyset from '../AccountCard.i18n';
import { MODES } from '../../../constants';
import css from './MainTab.module.css';
import Block from '../../../containers/Block';
import InfoForm from '../../../modules/info';
import YaTelephonyInfo from '../../../modules/yaTelephonyInfo';
import RsYaInfo from '../../../modules/rsYaInfo';
import Adfox from '../../../modules/adfox';
import Products from '../../../modules/products';
import Contracts from '../../../modules/contracts';
import Finance from '../../../modules/finance';
import Tags from '../../../modules/tags';
import Monetizators from '../../../modules/monetizators';
import Contacts, { Toolbar as ContactsToolbar } from '../../../modules/contacts';
import Comments from '../../../modules/comments';
import SubAccounts from '../../../modules/subAccounts';
import Factors from '../../../modules/factors';
import Domains from '../../../modules/domains';
import Issues from '../../../modules/issues';
import { Reports } from '../../../modules/reports/containers/Reports';
import { MainTabProps } from './MainTab.types';

const i18n = createI18N(keyset);
const i18nContacts = i18n('contacts');
const i18nCreate = createI18N(commonKeyset)('create');
const i18nTags = i18n('tags');
const i18nContracts = i18n('contracts');
const i18nUpsale = i18n('upsale');
const i18nMonetizators = i18n('monetizators');
const i18nComments = i18n('comments');

export class MainTab extends React.Component<MainTabProps> {
  private readonly newContactFormName = 'editContact:NEW';

  handleEditInfo = (...args) => this.props.edit(this.props.data.id, ...args);

  handleContactCreateSuccess = (contact) => {
    this.props.addContact(contact);
  };

  onSaveContact = (args) => {
    const {
      data: { id },
    } = this.props;
    return this.props.saveContact({ ...args, accountId: id });
  };

  onDeleteContact = (contactId) => this.props.removeContact(contactId);

  render() {
    if (!this.props.isLoad) {
      return null;
    }

    const {
      data: {
        id,
        info = {},
        yaTelephonyInfo,
        adfox,
        products,
        factors,
        domains,
        importedKiks = {},
        contacts = {},
        sysDates,
        tags,
        monetizators,
        services,
        agencyStat,
        agency,
        managers,
        appearanceKey,
        rsyaSspInfo = {},
        uiPermissions: {
          blocks = {},
          info: accessFields,
          yaTelephonyInfo: accessFieldsYaTelephonyInfo,
          adfox: accessFieldsAdfox,
          rsyaSsp: accessFiledsRsYa,
        },
        campaignId,
        commits = {},
      },
      chatId,
      accountId,
      isCompact,
      reload,
      mode,
    } = this.props;
    let dashboardClassName = css.dashboard;
    if (isCompact) {
      dashboardClassName += ` ${css.dashboard_compact}`;
    }

    return (
      <div className={dashboardClassName}>
        <TitleChain>
          {info.name}
          {info.login && ` (${info.login})`}
        </TitleChain>
        {mode !== MODES.TELEPHONY && mode !== MODES.TELEPHONY_READONLY && mode !== MODES.CHAT && (
          <div className={css.b__toolbar}>
            <AttributesPopup onSubmitSuccess={reload} appearanceKey={appearanceKey} />
          </div>
        )}
        <div className={css.row}>
          <div className={css.col}>
            <Block
              title={info.name}
              right={
                accessFields &&
                Access.isRead(accessFields.subclients) && (
                  <SubAccountsLink type={info.type} id={id} name={info.name} />
                )
              }
              access={blocks.info}
              color="#66C7FF"
            >
              <InfoForm
                form={`clientInfo:${id}`}
                onSubmit={this.handleEditInfo}
                initialValues={{ ...info, managers }}
                info={info}
                services={services}
                agencyStat={agencyStat}
                agency={agency}
                access={blocks.info}
                accessFields={accessFields}
                mode={mode}
                reload={reload}
                commits={commits}
              />
            </Block>
            <Block
              title={i18nContacts}
              access={blocks.contacts}
              color="#66C7FF"
              actions={[
                <ContactCreateButton
                  key="NEW_CONTACT"
                  formName={this.newContactFormName}
                  accountId={this.props.data.id}
                  onSubmitSuccess={this.handleContactCreateSuccess}
                >
                  {i18nCreate}
                </ContactCreateButton>,
              ]}
              toolbar={ContactsToolbar}
            >
              <Contacts
                access={blocks.contacts}
                contacts={contacts.items}
                importedKiks={importedKiks.items}
                onSave={this.onSaveContact}
                onDelete={this.onDeleteContact}
                accountId={id}
              />
            </Block>
            <Issues accountId={id} access={blocks.issues} />
          </div>
          <div className={css.col}>
            <Finance access={blocks.finance} client={id} key={id} />
            <Domains access={blocks.domains} items={domains} sysDates={sysDates} />
            <SubAccounts
              access={blocks.subAccounts}
              commits={commits.subAccounts}
              accountId={id}
              reload={reload}
              color="#FF8B8B"
            />
            {Access.isRead(blocks.aprilReports) && <Reports accountId={id} />}
            <div className={css.row}>
              <div className={css.col}>
                <Products data={products} access={blocks.products} />
                <Block title={i18nTags} access={blocks.tags} color="#66C7FF">
                  <Tags
                    className={css.tags}
                    id={id}
                    tags={tags}
                    placement="left"
                    canEdit={Access.isEdit(blocks.tags)}
                  />
                </Block>
                <Block title={i18nContracts} access={blocks.contracts} color="#66C7FF">
                  <Contracts name="contractsList" clientId={id} />
                </Block>
                <Block title={i18nUpsale} color="#66C7FF" access={blocks.upsale}>
                  <FactorBlocks
                    accountId={accountId}
                    campaignId={campaignId}
                    chatId={chatId}
                    accountLogin={info.login}
                    mode={mode}
                    isSupportSaveDraft
                    isSupportCopyToClipboard={mode === MODES.CHAT}
                  />
                </Block>
                <Factors access={blocks.factors} factors={factors} />
              </div>
              <div className={css.col}>
                <Block title={i18nMonetizators} access={blocks.monetizators} color="#66C7FF">
                  <Monetizators
                    className={css.tags}
                    id={id}
                    tags={monetizators}
                    placement="left"
                    canEdit={Access.isEdit(blocks.monetizators)}
                  />
                </Block>
                <Adfox data={adfox} access={blocks.adfox} accessFields={accessFieldsAdfox} />
                <YaTelephonyInfo
                  data={yaTelephonyInfo}
                  access={blocks.yaTelephonyInfo}
                  accessFields={accessFieldsYaTelephonyInfo}
                />
                <RsYaInfo
                  form={`RsYaInfo:${id}`}
                  onSubmit={this.handleEditInfo}
                  initialValues={rsyaSspInfo}
                  access={blocks.rsyaSsp}
                  mode={mode}
                  reload={reload}
                  commits={commits}
                  info={rsyaSspInfo}
                  accessFields={accessFiledsRsYa}
                />
                <Block title={i18nComments} access={blocks.comments} color="#58C665">
                  <Comments access={blocks.comments} accountId={id} />
                </Block>
              </div>
            </div>
          </div>
        </div>
      </div>
    );
  }
}
