import React, { memo } from 'react';
import Panel from 'modules/panel';
import { PanelScheme } from '@crm/components/dist/Panel';
import createI18N from '@yandex-int/i18n';
import { PanelFiles, PanelEntity } from 'modules/clientHistory';
import * as keyset from '../AccountCard.i18n';
import css from './Panel.module.css';

const i18n = createI18N(keyset);
const i18nAccountHistory = i18n('accountHistory');
const i18nAccountFiles = i18n('accountFiles');

interface Props {
  accountId: number;
}

const IssuePanel: React.FC<Props> = ({ accountId }) => {
  const panels: PanelScheme[] = [];

  panels.push({
    id: 'activity',
    title: i18nAccountHistory,
    content: (
      <div className={css.b__panel}>
        <PanelEntity key={accountId} param={{ clientId: accountId }} name="activity" loadOnMount />
      </div>
    ),
    keepMount: true,
    padding: false,
  });

  panels.push({
    id: 'files',
    title: i18nAccountFiles,
    content: (
      <div className={css.b__panel}>
        <PanelFiles
          key={accountId}
          param={{ clientId: accountId }}
          name="files"
          loadOnMount
          showTitle={false}
        />
      </div>
    ),
    keepMount: true,
    padding: false,
  });

  return <Panel maxWidth={600} name="account/attr" panels={panels} />;
};

export default memo(IssuePanel);
