import React, { FC } from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { AccountCardConnected } from './AccountCard';
import { AccountUrlContext } from './AccountUrlContext';
import { RedirectByClientId } from './RedirectByClientId';

export const AccountRouter: FC<RouteComponentProps<{ id: string }>> = (props) => {
  const query = new URLSearchParams(props.location.search);

  const clientId = Number(query.get('clientId'));
  if (clientId) {
    return <RedirectByClientId clientId={clientId} />;
  }

  const accountId = Number(props.match.params.id);
  if (accountId) {
    return (
      <AccountUrlContext.Provider value={props.match.url}>
        <AccountCardConnected id={accountId} />
      </AccountUrlContext.Provider>
    );
  }

  return null;
};

export default AccountRouter;
