import * as React from 'react';
import Button from '@crm/components/dist/lego2/Button';

interface Tab {
  NAME: string;
  TITLE: React.ReactNode;
}

interface Props {
  className?: string;
  tabs: Tab[];
  activeTab: string;
  onTabChange: (key: string) => void;
}

type PinProp = 'round-brick' | 'clear-round' | 'clear-brick';

const getPin = (index: number, length: number): PinProp | undefined => {
  if (length === 1) {
    return undefined;
  }

  if (index === 0) {
    return 'round-brick';
  }

  if (index === length - 1) {
    return 'clear-round';
  }

  return 'clear-brick';
};

const BlockToolbar = ({ className, tabs, activeTab, onTabChange }: Props) => (
  <div className={className}>
    {tabs.length > 0 &&
      tabs.map((item, index) => (
        <Button
          key={item.NAME}
          size="xs"
          pin={getPin(index, tabs.length)}
          view={activeTab !== item.NAME ? 'pseudo' : 'default'}
          onClick={() => onTabChange(item.NAME)}
        >
          {item.TITLE}
        </Button>
      ))}
  </div>
);

BlockToolbar.defaultProps = {
  className: undefined,
  tabs: [],
  activeTab: undefined,
  onTabChange: () => {},
};

export default BlockToolbar;
