import React, { useEffect, useState } from 'react';
import { Redirect } from 'react-router-dom';
import { RedirectByClientIdProps } from './RedirectByClientId.types';
import { loadAccount } from '../../api';

export const RedirectByClientId: React.FC<RedirectByClientIdProps> = ({ clientId }) => {
  const [accountId, setAccountId] = useState(0);

  useEffect(() => {
    const promise = loadAccount({ clientId }).then((data) => {
      setAccountId(data.id);

      return data;
    });

    return () => {
      promise.cancel();
    };
  }, [clientId]);

  if (!accountId) {
    return null;
  }

  return <Redirect to={`/account/${accountId}`} />;
};
