import React, { Component } from 'react';
import DumbBlock from '../components/Block';

class Block extends Component {
  constructor(props) {
    super(props);

    const { toolbar, tabs } = props;

    let activeTab = null;
    if (props.activeTab) {
      ({ activeTab } = props);
    } else if (toolbar) {
      activeTab = props.toolbar.DEFAULT_TAB.NAME;
    } else if (Array.isArray(tabs) && tabs.length) {
      activeTab = tabs[0].NAME;
    }

    this.state = {
      activeTab,
    };
  }

  onTabChange = newActiveTab => {
    this.setState({ activeTab: newActiveTab });
  };

  render() {
    if (this.props.toolbar || this.props.tabs) {
      return (
        <DumbBlock
          activeTab={this.state.activeTab}
          onTabChange={this.onTabChange}
          {...this.props}
        />
      );
    }

    return <DumbBlock {...this.props} />;
  }
}

export default Block;
