import React from 'react';
import PropTypes from 'prop-types';
import Block from 'pages/accounts/modules/info/components/Block';
import createI18N from '@yandex-int/i18n';
import * as keyset from './adfox.i18n';
import AdfoxFormContainer from './AdfoxFormContainer';

const i18nTitle = createI18N(keyset)('title');

const Adfox = props => {
  const { data, access, accessFields } = props;
  return (
    <Block title={i18nTitle} access={access} color="#66C7FF">
      <AdfoxFormContainer data={data} access={access} accessFields={accessFields} />
    </Block>
  );
};

Adfox.propTypes = {
  data: PropTypes.instanceOf(Object),
  access: PropTypes.number,
  accessFields: PropTypes.instanceOf(Object),
};

Adfox.defaultProps = {
  data: {},
  access: 0,
  accessFields: {
    platform: 3,
    logins: 3,
    adfoxPriority: 3,
    adServer: 3,
  },
};

export default Adfox;
