import React from 'react';
import PropTypes from 'prop-types';
import { reduxForm, propTypes } from 'redux-form';
import Button from '@crm/components/dist/lego2/Button';
import Toolbar from 'components/Toolbar';
import Access from 'utils/Access';
import ClientInput from 'pages/accounts/modules/info/modules/info/components/ClientInput';
import AdServerInput from 'pages/accounts/components/FormFields/AdServerInput';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import * as keyset from './adfox.i18n';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nPriorityNone = i18n('priorityNone');
const i18nPriorityA = i18n('priorityA');
const i18nPriorityB = i18n('priorityB');
const i18nPriorityC = i18n('priorityC');
const i18nAdfoxLogins = i18n('adfoxLogins');
const i18nSizePriority = i18n('sizePriority');
const i18nPlatformType = i18n('platformType');
const i18nMainAdServer = i18n('mainAdServer');
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');
const i18nEdit = commonI18n('edit');

const adfoxPriority = [
  { value: 'None', content: i18nPriorityNone },
  { value: 'A', content: i18nPriorityA },
  { value: 'B', content: i18nPriorityB },
  { value: 'C', content: i18nPriorityC },
];

const AdfoxForm = (props) => {
  const {
    handleSubmit,
    pristine,
    submitting,
    access,
    accessFields,
    onEdit,
    onCancel,
    isEdit,
  } = props;

  return (
    <form onSubmit={handleSubmit}>
      <div>
        <ClientInput
          labelText={i18nAdfoxLogins}
          name="logins"
          editComponent="TextInput"
          type="text"
          access={accessFields.logins}
        />
        <ClientInput
          labelText={i18nSizePriority}
          name="adfoxPriority"
          access={accessFields.adfoxPriority}
          editComponent="Select"
          options={adfoxPriority}
          hasEmptyValue={false}
        />
        <ClientInput
          labelText={i18nPlatformType}
          name="platform"
          access={accessFields.platform}
          editComponent="TextInput"
          type="text"
        />
        <ClientInput
          name="adServer"
          labelText={i18nMainAdServer}
          access={accessFields.adServer}
          editComponent={AdServerInput}
          previewComponent="PreviewDictionary"
          size="xs"
          isSingleValue
        />
      </div>
      {Access.isEdit(access) &&
        (isEdit ? (
          <Toolbar>
            <Button type="submit" view="action" disabled={pristine || submitting} size="xs">
              {i18nSave}
            </Button>
            <Button view="pseudo" onClick={onCancel} size="xs">
              {i18nCancel}
            </Button>
          </Toolbar>
        ) : (
          <div>
            <Button view="pseudo" onClick={onEdit} size="xs">
              {i18nEdit}
            </Button>
          </div>
        ))}
    </form>
  );
};

AdfoxForm.propTypes = {
  ...propTypes,
  accessFields: PropTypes.instanceOf(Object),
};

AdfoxForm.defaultProps = {
  accessFields: {},
};

export default reduxForm()(AdfoxForm);
