import React from 'react';
import PropTypes from 'prop-types';
import { jsonApiCall } from 'api/common';
import { reset } from 'redux-form';
import { connect } from 'react-redux';
import { unv } from 'utils/common';
import Access from 'utils/Access';
import AdfoxForm from './AdfoxForm';

class AdfoxFormContainer extends React.Component {
  static propTypes = {
    data: PropTypes.instanceOf(Array),
    accessFields: PropTypes.instanceOf(Object),
    dispatch: PropTypes.func.isRequired,
  }

  static defaultProps = {
    data: {},
    accessFields: {},
  }

  constructor(props) {
    super(props);

    this.form = 'adfox';
    this.state = { isEdit: false };
  }

  onSubmit = data => jsonApiCall({
    url: '/actions/account/adfox/save',
    data,
  }).then(() => {
    this.data = data;
    this.handleToggleEdit(false);
  });

  getAccessFields = (isEdit) => {
    const { accessFields } = this.props;

    return Object.keys(accessFields).reduce((pv, cv) => ({
      ...pv,
      [cv]: Access.and(
        accessFields[cv],
        Access.create({ read: true, edit: isEdit }),
      ),
    }), {});
  }

  handleToggleEdit = (flag) => {
    const isEdit = unv(flag, !this.state.isEdit);
    this.setState({ isEdit });
  }

  handleEdit = () => {
    this.handleToggleEdit(true);
  }

  handleCancel = () => {
    this.props.dispatch(reset(this.form));
    this.handleToggleEdit(false);
  }

  render() {
    const { data } = this.props;
    const { isEdit } = this.state;

    return React.createElement(AdfoxForm, {
      form: this.form,
      initialValues: this.data || data,
      onSubmit: this.onSubmit,
      onEdit: this.handleEdit,
      isEdit,
      enableReinitialize: true,
      ...this.props,
      onCancel: this.handleCancel,
      accessFields: this.getAccessFields(isEdit),
    });
  }
}

export default connect()(AdfoxFormContainer);
