import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { injectIntl } from 'react-intl';
import chartShipments from '../../containers/chartShipments';

class ChartShipments extends Component {
  componentDidMount() {
    this.setChart();
  }

  setChart() {
    const { data, title, intl, currency } = this.props;

    if (data.lines) {
      this.chart = chartShipments({
        data,
        title,
        intl,
        currency,
        targetNode: this.chartNode,
      });
    }
  }

  componentWillUnmount() {
    this.chart && this.chart.destroy();
  }
  setRef = (node) => {
    this.chartNode = node;
  };
  render() {
    return <div className={this.props.className} ref={this.setRef} />;
  }
}

ChartShipments.propTypes = {
  data: PropTypes.shape({
    chart: PropTypes.instanceOf(Object),
  }),
  title: PropTypes.string,
  intl: PropTypes.instanceOf(Object),
};

ChartShipments.defaultProps = {
  data: {},
  title: undefined,
};

export default injectIntl(ChartShipments);
