import React, { Component } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import ChartGrowth from './chartGrowth';
import ChartShipments from './chartShipments';
import css from './styles.modules.scss';

const defaultCurrency = { code: 'rub' };

class Charts extends Component {
  render() {
    const {
      charts: { growth, shipments, currency = defaultCurrency },
    } = this.props;

    return (
      <div className={css.root}>
        {growth && (
          <ChartGrowth currency={currency} className={cx(css.chart, css.growth)} data={growth} />
        )}
        {shipments && (
          <ChartShipments
            currency={currency}
            className={cx(css.chart, css.shipments)}
            data={shipments}
          />
        )}
      </div>
    );
  }
}

Charts.propTypes = {
  charts: PropTypes.shape({
    data: PropTypes.shape({
      growth: PropTypes.instanceOf(Object),
      shipments: PropTypes.instanceOf(Object),
      currency: PropTypes.instanceOf(Object),
    }),
  }),
};

Charts.defaultProps = {
  charts: {},
};

export default Charts;
