import css from './styles.modules.scss';

const toolTip = (title, data) =>
  `<div class=${css.title}>${title}</div><table class=${css.content}>${data}</table>`;

const toolTipItem = (point, currencyName) => `
  <tr>
    <td class=${css.label} style="color: ${point.series.color}">
      ${point.series.name}:
    </td>
    <td class=${css.value}>
      ${typeof point.y === 'number' &&
        `${(point.y.toFixed() / 1).toLocaleString()} ${currencyName}`}
    </td>
  </tr>
`;

export default toolTip;
export { toolTipItem };
