import Highcharts from './highcharts';
import toolTip, { toolTipItem } from '../components/Tooltip';
import { currencyList } from './constants';

const chartShipments = (props) => {
  const { data: chart, intl, targetNode, currency } = props;
  const series = [];
  const chartLabels = chart.labels;

  chart.lines.forEach((item) => {
    const markerVisible = item.points !== null && item.points.length === 1;
    const line = {
      name: item.name,
      data: item.points,
      pointStart: item.offset,

      animation: false,
      marker: {
        enabled: markerVisible,
      },
    };

    series.push(line);
  });

  const currencyName = currencyList[currency.code];
  return new Highcharts.Chart({
    chart: {
      renderTo: targetNode,
      type: 'spline',
      height: 230,
    },
    colors: ['#03ad00', '#F7B12C', '#0085bf'],
    credits: {
      enabled: false,
    },
    title: {
      text: chart.name,
    },
    xAxis: {
      // min: 0,
      type: 'datetime',
      labels: {
        formatter() {
          return this.value % 1 === 0
            ? intl.formatDate(new Date(chartLabels[this.value]), {
                month: 'short',
                day: 'numeric',
              })
            : '';
        },
      },
    },
    yAxis: {
      min: 0,
      title: {
        text: currencyName,
      },
    },
    tooltip: {
      shared: true,
      useHTML: true,
      formatter() {
        const x =
          this.x % 1 === 0
            ? intl.formatDate(new Date(chartLabels[this.x]), {
                year: 'numeric',
                month: 'short',
                day: 'numeric',
              })
            : '';
        const data = this.points.reduceRight(
          (prevPoint, point) => prevPoint + toolTipItem(point, currencyName),
          '',
        );

        return toolTip(x, data);
      },
    },
    series,
  });
};

export default chartShipments;
