/* eslint-disable import/prefer-default-export */

import { apiCall3 } from 'api/common';
import { actions as listActions } from 'containers/InfiniteList';

export const commentActionsFactory = (dispatch, accountId) => {
  const actionsCategory = `COMMENTS_${accountId}`;

  return {
    loadComments: args => apiCall3('/view/account/comments', { accountId, ...args }),
    refreshComments: () => dispatch(listActions.refresh(actionsCategory)),

    addComment: values =>
      apiCall3('/actions/account/comments/add', { accountId, ...values }, 'post', false),

    updateComment: (commentId, text) =>
      apiCall3(
        '/actions/account/comments/edit',
        { accountId, commentId, text },
        'post',
        false,
      ).then(() => {
        dispatch(listActions.refresh(actionsCategory));
        return null;
      }),

    deleteComment: commentId =>
      apiCall3('/actions/account/comments/delete', { accountId, commentId }, 'post', false).then(
        () => {
          dispatch(listActions.refresh(actionsCategory));
          return null;
        },
      ),
  };
};
