import React from 'react';
import cx from 'classnames';
import { isSubmitting } from 'redux-form';
import { connect } from 'react-redux';
import CommentForm from 'forms/Comment';
import Spinner from 'components/Spinner';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import * as keyset from './NewComment.i18n';
import { commentActionsFactory } from '../../actions';
import css from './styles.modules.scss';

const i18nComment = createI18N(keyset)('comment');
const i18nSend = createI18N(commonKeyset)('send');

const mapDispatch = (dispatch, props) => ({
  dispatch,
  commentActions: commentActionsFactory(dispatch, props.accountId),
});

const CLIENT_NEW_COMMENT = 'CLIENT_NEW_COMMENT';

const mapState = state => ({ submitting: isSubmitting(CLIENT_NEW_COMMENT)(state) });

@connect(mapState, mapDispatch)
export default class Form extends React.Component {
  render() {
    const { submitting, className } = this.props;

    return (
      <Spinner overlay visible={submitting}>
        <CommentForm
          className={cx(css.root, className)}
          form={CLIENT_NEW_COMMENT}
          onSubmit={this.props.commentActions.addComment}
          onSuccess={this.props.onSend}
          okButtonLabel={i18nSend}
          filesObjectName="accountComment"
          placeholder={i18nComment}
        />
      </Spinner>
    );
  }
}
