import React from 'react';
import PropTypes from 'prop-types';
import { InfiniteListView, actions as listActions } from 'containers/InfiniteList';
import { connect } from 'react-redux';
import Access from 'utils/Access';
import css from '../styles.modules.scss';
import { commentActionsFactory } from '../actions';
import ClientComment from '../components/ClientComment';
import NewComment from '../components/NewComment';

const getName = id => `COMMENTS_${id}`;

const mapDispatch = (dispatch, props) => ({
  dispatch,
  commentActions: commentActionsFactory(dispatch, props.accountId),
});

@connect(null, mapDispatch)
export default class Comments extends React.Component {
  static propTypes = {
    commentActions: PropTypes.instanceOf(Object).isRequired,
    dispatch: PropTypes.func.isRequired,
    accountId: PropTypes.number.isRequired,
    access: PropTypes.number,
  }

  static defaultProps = {
    access: undefined,
  }

  componentDidMount() {
    this.props.dispatch(listActions.load(getName(this.props.accountId)));
  }

  render() {
    const {
      commentActions,
      accountId,
      dispatch,
      access,
    } = this.props;

    return (
      <div className={css.root}>
        {
          Access.isEdit(access) &&
          <NewComment
            className={css.form}
            form={`NEW_COMMENT_${accountId}`}
            accountId={accountId}
            onSend={() => { dispatch(listActions.reload(getName(accountId))); }}
          />
        }
        <InfiniteListView
          name={getName(accountId)}
          onLoad={commentActions.loadComments}
          component={ClientComment}
          className={css.list}
          itemProps={{ accountId, viewOnly: !Access.isEdit(access) }}
          withNavigation={false}
        />
      </div>
    );
  }
}
