/*
eslint-disable import/prefer-default-export
*/

const commentUpdater = ({ commentId, text }) => state => {
  try {
    const index = state.items.findIndex(item => item.id === commentId);
    return {
      ...state,
      items: [
        ...state.items.slice(0, index),
        {
          ...state.items[index],
          text,
        },
        ...state.items.slice(index + 1),
      ],
    };
  } catch (e) {
    /* empty */
  }

  return state;
};

export { commentUpdater };
