/* global confirm */
/*
eslint-disable
no-restricted-globals,
no-alert,
*/
import * as React from 'react';
import { connect } from 'react-redux';
import { CallToComponentType, ContactFull } from 'components/Contact';
import { ContactData } from 'types';
import { ContactCreateModal } from 'modules/contactCreateForm';
import createI18N from '@yandex-int/i18n';
import { getInitialValues } from 'components/Contact/utils';
import { config } from 'services/Config';
import { CallToUseLogBroker } from 'modules/issues/components/CallToUseLogBroker';
import { CallTo } from 'modules/issues/components/CallTo/CallTo';
import { updateContact } from '../../../../actions';
import * as keyset from './Contact.i18n';

const i18n = createI18N(keyset);

interface Props {
  className?: string;
  canEdit?: boolean;
  contact: ContactData;
  accountId: number;
  id: number;
  dispatch: (action: unknown) => void;
  onDelete: (contactId: ContactData['contactId']) => void;
}

class ConnectedContact extends React.Component<Props> {
  private formName: string;

  public constructor(props) {
    super(props);

    this.formName = `editContact:${this.props.contact.contactId}`;
  }

  private handleDelete = () => {
    const { contact } = this.props;
    const { contactId } = contact;
    const { firstName = '', middleName = '', lastName = '' } = contact;
    const result = confirm(
      i18n('removeConfirm', { contactName: `${firstName} ${middleName} ${lastName}` }),
    );

    if (!result) return;

    this.props.onDelete(contactId);
  };

  private handleEdit = () => {
    const initialValues = getInitialValues(this.props.contact);
    const { accountId } = this.props;
    const { contactId } = this.props.contact;

    ContactCreateModal.open({
      form: this.formName,
      onSubmitSuccess: (contact) => this.props.dispatch(updateContact(contact)),
      initialValues,
      accountId,
      contactId,
    });
  };

  public render(): React.ReactElement {
    let callToComponent: CallToComponentType | undefined;

    if (config.value.features.personalUnits) {
      if (config.value.features.useYaCallsLB) {
        callToComponent = CallToUseLogBroker;
      } else if (config.value.features.useYaCalls) {
        callToComponent = CallTo;
      }
    }

    return (
      <ContactFull
        {...this.props}
        callToComponent={callToComponent}
        canWriteMail
        withEmptyActionsPlaceholder
        onEdit={this.handleEdit}
        onDelete={this.handleDelete}
      />
    );
  }
}

export default connect()(ConnectedContact);
